#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;

varying vec4 fragColor;
#else
in vec3 inVertex;
in vec3 inNormal;

out vec4 fragColor;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform vec4 inColor;
uniform vec3 specularColor;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;
uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

uniform float brightness;

void main()
{
	vec3 diffuse, specular;
	
	/* first transform the normal into eye space and normalize the result */
	vec3 hV = normalize(lightSource1HV + lightSource2HV);
	
	/* bump up the lambert to make things more visible */
	float lambert = (max(0.0, dot(inNormal, lightSource1))
		                + max(0.0, dot(inNormal, lightSource2)));
	
	specular = pow(max(0.0, dot(inNormal, hV)), 8.0) * 0.35 * specularColor;
	diffuse = inColor.rgb * (lambert * (0.75 * 0.75) * brightness);
	vec3 color = specular + diffuse;
	float factor = dot(inNormal, vec3(0.0, 0.0, 1.0));
	
	/* red book p. 221 */
	fragColor = vec4(mix(color, inColor.rgb * brightness, factor), inColor.a);
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
